/*
 * (c) 2015 Mechatronik Karl Zeilhofer
 * karl@zeilhofer.co.at
 *
 * If you want to use or modify the sourcecode, please contact me.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QThread>
#include "restorer.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

    QThread workerThread;

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    void finished();
    void updateFileName(QString fn);

private slots:
    void on_pushButton_sourcePath_clicked();
    void on_pushButton_start_clicked();

    void on_actionAbout_triggered();

    void on_actionOnlineHelp_triggered();

    void on_actionAbout_Qt_triggered();

private:
    Ui::MainWindow *ui;
    Restorer* restorer;

signals:
    void operate(QString root);
};

#endif // MAINWINDOW_H
